/**
 * 
 */
package com.ejie.ab18a.security.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerException;

import n38c.exe.N38API;

import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ejie.ab18a.properties.Ab18aPropertiesManager;
import com.ejie.ab18a.security.Ab18aSeguridadBean;
import com.ejie.ab18a.utils.Constantes;
import com.ejie.ab18a.utils.Utilidades;

/**
 * @author XXXX
 * 
 */
public class Ab18aObtenerDatosXLNETS {

	/** The Constant LOGGER. */
	private static final Logger logger = LoggerFactory.getLogger(Ab18aObtenerDatosXLNETS.class);
	private static final String CTE_LETRAS_CONTROL_NIF = "TRWAGMYFPDXBNJZSQVHLCKE";
	private static final String NIF_STRING_ASOCIATION = "TRWAGMYFPDXBNJZSQVHLCKET";
	private static final int LONGITUD_NIF = 9;

	/**
	 * Instantiates a new Y46j obtener datos xlnets.
	 */
	private Ab18aObtenerDatosXLNETS() {
	}

	/**
	 * Obtener datos xlnets.
	 * 
	 * @param httpRequest
	 *            the http request
	 * @param Y46jSeguridadBean
	 *            the Y46j seguridad bean
	 */
	public static void obtenerDatosXLNETS(HttpServletRequest httpRequest, Ab18aSeguridadBean ab18aSeguridadBean) {
		String filtro;
		NodeList nodelist = null;
		Document doc = null;

		// *********************************//

		try {
			N38API n38API = new N38API(httpRequest);
			// Document doc = n38API.n38ItemObtenerAutorizacion(FUNCION);
			if (Ab18aPropertiesManager.getProperty(Constantes.PROP_ENTORNO_AB18A) != null
					&& Ab18aPropertiesManager.getProperty(Constantes.PROP_ENTORNO_AB18A).equalsIgnoreCase(Constantes.PROP_ENTORNO_LOCAL)) {
				doc = Utilidades.string2Document(Ab18aObtenerDatosXLNETS.getN38SesionXML());
			} else {
				// ********************************************
				// *********** X M L -- S E S I O N ***********
				// ********************************************
				// recogemos el xml de sesion.
				doc = n38API.n38ItemSesion();
				Ab18aObtenerDatosXLNETS.logger.debug("DOCUMENT: '" + Utilidades.getStringFromDocument(doc) + "'");
			}

			if (doc != null) {

				Ab18aObtenerDatosXLNETS.logger.debug("## doc!=null");

				String dniParametroXLNETS = null;

				try {
					String[] valoresDNI = n38API.n38ItemSesion(N38API.NOMBRE_DNI);
					Ab18aObtenerDatosXLNETS.logger.debug("DNIS XLNETS ..." + valoresDNI.toString());
					if (valoresDNI != null && valoresDNI.length > 0) {
						for (int i = 0; i < valoresDNI.length; i++) {
							dniParametroXLNETS = valoresDNI[i];
							break;
						}
					} else {
						Ab18aObtenerDatosXLNETS.logger.debug("## no hay valores para el paramtro DNI de xlnets");
					}
				} catch (Exception e) {
					Ab18aObtenerDatosXLNETS.logger.error("## Error el obtener el parametro xlnets: " + e.getMessage());
				}
				Ab18aObtenerDatosXLNETS.logger.debug("## dniParametroXLNETS: " + dniParametroXLNETS);

				filtro = "//elementos";
				nodelist = XPathAPI.selectNodeList(doc, filtro);
				if ((nodelist != null && nodelist.getLength() > 0)) {

					// Buscamos los datos de certificacion ONA
					if (doc != null && doc.getElementsByTagName("elementos") != null && doc.getElementsByTagName("elementos").getLength() > 0) {

						// obtener los perfiles del usuario de XLNETS
						// Y46jSeguridadBean.setListaPerfiles(obtenerValoresToken("n38perfiles",
						// doc, "Y46j"));
						// obtener el login del usuario de XLNETS
						ab18aSeguridadBean.setLogin(Ab18aObtenerDatosXLNETS.obtenerValorToken("n38personauid", doc));
						// obtener dni o cif del usuario de XLNETS
						String value = Ab18aObtenerDatosXLNETS.obtenerValorToken("n38subjectcert", doc);

						Ab18aObtenerDatosXLNETS.logger.debug("## value: " + value);

						if (value != null && !value.equals("NO")) {

							Ab18aObtenerDatosXLNETS.logger.debug("## diferente de NO");

							String asuntoCertificado = value;
							// Obtener el nombre, apellidos y DNI para el asunto
							// recogido.
							final String dniCif = dameDeAsuntoDNICIF(asuntoCertificado, dniParametroXLNETS);
							ab18aSeguridadBean.setDni(dniCif);
							Ab18aObtenerDatosXLNETS.logger.debug("El DNI/CIF recuperados para el certificado son:'" + dniCif + "'.");
						} else {
							String dni = nifFromDni(Ab18aObtenerDatosXLNETS.obtenerValorToken("dni", doc));
							ab18aSeguridadBean.setDni(dni);

							Ab18aObtenerDatosXLNETS.logger.debug("Y46jSeguridadBean.getDni(): " + ab18aSeguridadBean.getDni());
						}
					} else {
						Ab18aObtenerDatosXLNETS.logger
								.error("El usuario logeado no puede acceder a la aplicacion V21a porque no tiene autorizacion para la funcion XLNETS .");
					}
				}
			}
		} catch (Exception e) {
			Ab18aObtenerDatosXLNETS.logger.error("Error al obtener los datos del usuario conectado de XLNETS...");
		}
	}

	/**
	 * Gets the n38 sesion xml.
	 * 
	 * @return the n38 sesion xml
	 */
	private static String getN38SesionXML() {
		StringBuffer sb = new StringBuffer(Constantes.CTE_STRINGBUFFER_7000);
		// sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?><n38><elementos tipo=\"n38APISesionCrearToken\"><elemento subtipo=\"N38Sesion\"><parametro id=\"n38fhum\"><valor>1299081888126</valor></parametro><parametro id=\"cn\"><valor>Q99L1291026053027</valor></parametro><parametro id=\"n38uidsesion\"><valor>1291037690878</valor></parametro><parametro id=\"n38login\"><valor>Q99L</valor></parametro><parametro id=\"n38perfiles\"><valor>Publico</valor><valor>W20-PF-0103</valor><valor>X53JS-PF-0002</valor><valor>X43F-PF-0005</valor><valor>R02S-PF-0003</valor><valor>T71B-PF-0006</valor><valor>V79J-PF-0001</valor><valor>V58JS-PF-0002</valor><valor>V58JS-PF-0001</valor><valor>K41-PF-0148</valor><valor>R02D-PF-0002</valor><valor>S62S-PF-0002</valor><valor>M01B-PF-0011</valor><valor>R02F-PF-0005</valor><valor>Q99L-PF-0027</valor><valor>Q99L-PF-0025</valor><valor>Q99L-PF-0024</valor><valor>Q99L-PF-0023</valor><valor>Q99L-PF-0022</valor><valor>Q99L-PF-0021</valor><valor>Q99L-PF-0020</valor><valor>Q99L-PF-0019</valor><valor>Q99L-PF-0018</valor><valor>Q99L-PF-0017</valor><valor>Q99L-PF-0016</valor><valor>Q99L-PF-0015</valor><valor>Q99L-PF-0014</valor><valor>Q99L-PF-0013</valor><valor>Q99L-PF-0012</valor><valor>Q99L-PF-0011</valor><valor>Q99L-PF-0010</valor><valor>Q99L-PF-0009</valor><valor>Q99L-PF-0008</valor><valor>Q99L-PF-0007</valor><valor>Q99L-PF-0006</valor><valor>Q99L-PF-0005</valor><valor>Q99L-PF-0004</valor><valor>Q99L-PF-0003</valor><valor>Q99L-PF-0002</valor><valor>Q99L-PF-0001</valor><valor>R02L-PF-0006</valor></parametro><parametro id=\"n38organizacion\"><valor>400</valor></parametro><parametro id=\"iphostnumber\"><valor>10.190.20.40</valor></parametro><parametro id=\"n38reintentossesion\"><valor>1</valor></parametro><parametro id=\"n38sexpiracion\"><valor>988999999999</valor></parametro><parametro id=\"n38tiposesion\"><valor>C/S</valor></parametro><parametro id=\"n38puestouid\"><valor>Q99L</valor></parametro><parametro id=\"n38fechacreacion\"><valor>1291026053027</valor></parametro><parametro id=\"n38personauid\"><valor>Q99L</valor></parametro><parametro id=\"n38fechalogoff\"><valor /></parametro><parametro id=\"n38valorhash\"><valor>+3yZRBdn9vfchOUm97IZTiiepUk=</valor></parametro><parametro id=\"n38fechainicio\"><valor>1291026053027</valor></parametro><parametro id=\"n38idioma\"><valor>3</valor></parametro><parametro id=\"dni\"><valor>Q99L</valor></parametro><parametro id=\"n38comportamientoip\"><valor>ipv</valor></parametro><parametro id=\"n38idcontexto\"><valor>intranet</valor><valor>internet</valor></parametro><parametro id=\"n38loginasociado\"><valor>https://xlnets.servicios.jakina.ejiedes.net:443/n38a/N38LoginInicioServlet</valor></parametro><parametro id=\"n38listacede\"><valor>x_cddes01:48880:1000</valor><valor>x_cddes02:48880:1000</valor></parametro><parametro id=\"n38comportamientofirma\"><valor>False</valor></parametro><parametro id=\"n38exclusivo\"><valor>False</valor></parametro><parametro id=\"n38dominiouid\"><valor>D0_Servidores11</valor></parametro><parametro id=\"n38urlsredireccion\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38nWar/N38NodoEstrellaServlet</valor></parametro><parametro id=\"n38listags\"><valor>x_ssdes01:47770:1000</valor><valor>x_ssdes02:47770:1000</valor></parametro><parametro id=\"n38rangoip\"><valor>10.200.56.11</valor><valor>10.170.9.109</valor><valor>10.170.8.4</valor><valor>10.170.8.5</valor><valor>10.170.9.4</valor><valor>10.170.9.5</valor><valor>10.170.9.137</valor><valor>10.170.9.79</valor><valor>10.200.56.57</valor><valor>10.170.17.114</valor><valor>10.200.8.216</valor><valor>10.200.8.217</valor><valor>10.200.8.218</valor><valor>10.190.8.14</valor><valor>10.170.17.105</valor><valor>192.168.56.231</valor><valor>192.168.56.233</valor><valor>192.168.56.242</valor><valor>192.168.56.241</valor><valor>10.190.20.25</valor><valor>10.190.24.15</valor><valor>192.168.56.234</valor><valor>10.190.8.101</valor><valor>10.190.20.20</valor><valor>192.168.56.21</valor><valor>192.168.56.13</valor><valor>192.168.56.17</valor><valor>192.168.56.11</valor><valor>192.168.56.228</valor><valor>10.170.8.216</valor><valor>192.168.56.58</valor><valor>10.190.20.14</valor><valor>10.170.17.201</valor><valor>555.</valor><valor>10.190.20.43</valor><valor>10.190.20.47</valor><valor>10.190.20.32</valor><valor>10.190.20.40</valor><valor>10.190.20.11</valor><valor>10.190.20.56</valor><valor>10.190.20.38</valor><valor>10.190.8.69</valor><valor>10.190.8.70</valor><valor>10.170.17.200</valor><valor>10.190.20.50</valor><valor>10.190.40.15</valor><valor>10.190.40.16</valor><valor>10.190.40.18</valor><valor>10.190.40.19</valor><valor>10.190.20.69</valor><valor>10.190.20.70</valor><valor>10.170.9.21</valor><valor>10.190.20.67</valor><valor>10.170.16.172</valor><valor>10.190.20.100</valor><valor>10.190.20.102</valor><valor>10.190.20.63</valor><valor>10.190.20.64</valor><valor>10.170.17.203</valor></parametro><parametro id=\"n38dominioscookies\"><valor>.jakina.ejgvdns</valor></parametro><parametro id=\"n38listamsservidores\"><valor>hola Aitzi</valor></parametro><parametro id=\"n38servidoraudit\"><valor>x_auddes01:4560</valor></parametro><parametro id=\"n38subjectcert\"><valor>NO</valor></parametro><parametro id=\"n38certificadopoliticas\"><valor>NO</valor></parametro><parametro id=\"n38oleserver\"><valor>false</valor></parametro><parametro id=\"n38cadescripciondominio\"><valor>ras internete</valor></parametro><parametro id=\"n38eudescripciondominio\"><valor>rak Interneta</valor></parametro><parametro id=\"n38crearsesionapp\"><valor>true</valor></parametro><parametro id=\"n38urlportal\"><valor>https://xlnets.servicios.jakina.ejiedes.net/n38a/N38servletPortal</valor></parametro><parametro id=\"n38urldispatcher\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38nWar/N38DispatcherEstrellaServlet</valor></parametro><parametro id=\"n38urlsgsd\"><valor>https://xlnets.servicios.jakina.ejiedes.net/n38nCDominioWar/N38GestorCDominioServlet</valor></parametro><parametro id=\"n38dominiocomuncookie\"><valor>.jakina.ejgvdns</valor></parametro><parametro id=\"n38sistemaxlnetsuid\"><valor>desarrollo-produccion</valor></parametro><parametro id=\"n38direccionproxy\"><valor>http://www.servicios.comunes.ejiedes.net/proxy</valor></parametro><parametro id=\"n38direcciongrc\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38rWar/N38rFachadaGRCServlet</valor></parametro><parametro id=\"n38grupoorganicouid\"><valor /></parametro><parametro id=\"n38orgunituid\"><valor /></parametro><parametro id=\"n38urlfinal\"><valor>http://www.euskadi.net</valor></parametro><parametro id=\"n38uidsesionglobal\"><valor>desarrollo-produccion-1291037690878</valor></parametro><parametro id=\"n38cadenaconfianza\"><valor>desarrollo-produccion</valor></parametro><parametro id=\"n38politicauid\"><valor>P2</valor></parametro></elemento></elementos></n38>");
		sb.append("<?xml version='1.0' encoding='ISO-8859-1' ?><n38><elementos tipo='n38APISesionCrearToken'><elemento subtipo='N38Sesion'><parametro id='n38fhum'><valor>1299081888126</valor></parametro><parametro id='cn'><valor>Q99L1291026053027</valor></parametro><parametro id='n38uidsesion'><valor>1291037690878</valor></parametro><parametro id='n38login'><valor>Q99L</valor></parametro><parametro id='n38perfiles'><valor>Publico</valor><valor>W20-PF-0103</valor><valor>X53JS-PF-0002</valor><valor>X43F-PF-0005</valor><valor>R02S-PF-0003</valor><valor>T71B-PF-0006</valor><valor>V79J-PF-0001</valor><valor>V58JS-PF-0002</valor><valor>V58JS-PF-0001</valor><valor>K41-PF-0148</valor><valor>R02D-PF-0002</valor><valor>S62S-PF-0002</valor><valor>M01B-PF-0011</valor><valor>R02F-PF-0005</valor><valor>Q99L-PF-0027</valor><valor>Q99L-PF-0025</valor><valor>Q99L-PF-0024</valor><valor>Q99L-PF-0023</valor><valor>Q99L-PF-0022</valor><valor>Q99L-PF-0021</valor><valor>Q99L-PF-0020</valor><valor>Q99L-PF-0019</valor><valor>Q99L-PF-0018</valor><valor>Q99L-PF-0017</valor><valor>Q99L-PF-0016</valor><valor>Q99L-PF-0015</valor><valor>Q99L-PF-0014</valor><valor>Q99L-PF-0013</valor><valor>Q99L-PF-0012</valor><valor>Q99L-PF-0011</valor><valor>Q99L-PF-0010</valor><valor>Q99L-PF-0009</valor><valor>Q99L-PF-0008</valor><valor>Q99L-PF-0007</valor><valor>Q99L-PF-0006</valor><valor>Q99L-PF-0005</valor><valor>Q99L-PF-0004</valor><valor>Q99L-PF-0003</valor><valor>Q99L-PF-0002</valor><valor>Q99L-PF-0001</valor><valor>R02L-PF-0006</valor></parametro><parametro id='n38organizacion'><valor>400</valor></parametro><parametro id='iphostnumber'><valor>10.190.20.40</valor></parametro><parametro id='n38reintentossesion'><valor>1</valor></parametro><parametro id='n38sexpiracion'><valor>988999999999</valor></parametro><parametro id='n38tiposesion'><valor>C/S</valor></parametro><parametro id='n38puestouid'><valor>Q99L</valor></parametro><parametro id='n38fechacreacion'><valor>1291026053027</valor></parametro><parametro id='n38personauid'><valor>Q99L</valor></parametro><parametro id='n38fechalogoff'><valor /></parametro><parametro id='n38valorhash'><valor>+3yZRBdn9vfchOUm97IZTiiepUk=</valor></parametro><parametro id='n38fechainicio'><valor>1291026053027</valor></parametro><parametro id='n38idioma'><valor>3</valor></parametro><parametro id='dni'><valor>15151515</valor></parametro><parametro id='n38comportamientoip'><valor>ipv</valor></parametro><parametro id='n38idcontexto'><valor>intranet</valor><valor>internet</valor></parametro><parametro id='n38loginasociado'><valor>https://xlnets.servicios.jakina.ejiedes.net:443/n38a/N38LoginInicioServlet</valor></parametro><parametro id='n38listacede'><valor>x_cddes01:48880:1000</valor><valor>x_cddes02:48880:1000</valor></parametro><parametro id='n38comportamientofirma'><valor>False</valor></parametro><parametro id='n38exclusivo'><valor>False</valor></parametro><parametro id='n38dominiouid'><valor>D0_Servidores11</valor></parametro><parametro id='n38urlsredireccion'><valor>http://xlnets.servicios.jakina.ejiedes.net/n38nWar/N38NodoEstrellaServlet</valor></parametro><parametro id='n38listags'><valor>x_ssdes01:47770:1000</valor><valor>x_ssdes02:47770:1000</valor></parametro><parametro id='n38rangoip'><valor>10.200.56.11</valor><valor>10.170.9.109</valor><valor>10.170.8.4</valor><valor>10.170.8.5</valor><valor>10.170.9.4</valor><valor>10.170.9.5</valor><valor>10.170.9.137</valor><valor>10.170.9.79</valor><valor>10.200.56.57</valor><valor>10.170.17.114</valor><valor>10.200.8.216</valor><valor>10.200.8.217</valor><valor>10.200.8.218</valor><valor>10.190.8.14</valor><valor>10.170.17.105</valor><valor>192.168.56.231</valor><valor>192.168.56.233</valor><valor>192.168.56.242</valor><valor>192.168.56.241</valor><valor>10.190.20.25</valor><valor>10.190.24.15</valor><valor>192.168.56.234</valor><valor>10.190.8.101</valor><valor>10.190.20.20</valor><valor>192.168.56.21</valor><valor>192.168.56.13</valor><valor>192.168.56.17</valor><valor>192.168.56.11</valor><valor>192.168.56.228</valor><valor>10.170.8.216</valor><valor>192.168.56.58</valor><valor>10.190.20.14</valor><valor>10.170.17.201</valor><valor>555.</valor><valor>10.190.20.43</valor><valor>10.190.20.47</valor><valor>10.190.20.32</valor><valor>10.190.20.40</valor><valor>10.190.20.11</valor><valor>10.190.20.56</valor><valor>10.190.20.38</valor><valor>10.190.8.69</valor><valor>10.190.8.70</valor><valor>10.170.17.200</valor><valor>10.190.20.50</valor><valor>10.190.40.15</valor><valor>10.190.40.16</valor><valor>10.190.40.18</valor><valor>10.190.40.19</valor><valor>10.190.20.69</valor><valor>10.190.20.70</valor><valor>10.170.9.21</valor><valor>10.190.20.67</valor><valor>10.170.16.172</valor><valor>10.190.20.100</valor><valor>10.190.20.102</valor><valor>10.190.20.63</valor><valor>10.190.20.64</valor><valor>10.170.17.203</valor></parametro><parametro id='n38dominioscookies'><valor>.jakina.ejgvdns</valor></parametro><parametro id='n38listamsservidores'><valor>hola Aitzi</valor></parametro><parametro id='n38servidoraudit'><valor>x_auddes01:4560</valor></parametro><parametro id='n38subjectcert'><valor>NO</valor></parametro><parametro id='n38certificadopoliticas'><valor>NO</valor></parametro><parametro id='n38oleserver'><valor>false</valor></parametro><parametro id='n38cadescripciondominio'><valor>ras internete</valor></parametro><parametro id='n38eudescripciondominio'><valor>rak Interneta</valor></parametro><parametro id='n38crearsesionapp'><valor>true</valor></parametro><parametro id='n38urlportal'><valor>https://xlnets.servicios.jakina.ejiedes.net/n38a/N38servletPortal</valor></parametro><parametro id='n38urldispatcher'><valor>http://xlnets.servicios.jakina.ejiedes.net/n38nWar/N38DispatcherEstrellaServlet</valor></parametro><parametro id='n38urlsgsd'><valor>https://xlnets.servicios.jakina.ejiedes.net/n38nCDominioWar/N38GestorCDominioServlet</valor></parametro><parametro id='n38dominiocomuncookie'><valor>.jakina.ejgvdns</valor></parametro><parametro id='n38sistemaxlnetsuid'><valor>desarrollo-produccion</valor></parametro><parametro id='n38direccionproxy'><valor>http://www.servicios.comunes.ejiedes.net/proxy</valor></parametro><parametro id='n38direcciongrc'><valor>http://xlnets.servicios.jakina.ejiedes.net/n38rWar/N38rFachadaGRCServlet</valor></parametro><parametro id='n38grupoorganicouid'><valor /></parametro><parametro id='n38orgunituid'><valor /></parametro><parametro id='n38urlfinal'><valor>http://www.euskadi.net</valor></parametro><parametro id='n38uidsesionglobal'><valor>desarrollo-produccion-1291037690878</valor></parametro><parametro id='n38cadenaconfianza'><valor>desarrollo-produccion</valor></parametro><parametro id='n38politicauid'><valor>P2</valor></parametro></elemento></elementos></n38>");
		return sb.toString();

	}

	/**
	 * Obtiene el valor del xml de session segun el token.
	 * 
	 * @param token
	 *            the token
	 * @param doc
	 *            the doc
	 * @return el valor del token
	 */
	private static String obtenerValorToken(String token, Document doc) {
		String filtro = null;
		Node nodo = null;
		String resultado = null;

		try {
			filtro = "//elemento[@subtipo=\"N38Sesion\"]/parametro[@id=\"" + token + "\"]/valor/text()";
			nodo = XPathAPI.selectSingleNode(doc, filtro);

			if (nodo != null) {
				resultado = nodo.getNodeValue();
				Ab18aObtenerDatosXLNETS.logger.debug("Valor del resultado-->" + resultado);
			}
		} catch (TransformerException e) {

			resultado = null;
			Ab18aObtenerDatosXLNETS.logger.error("No es posible acceder al parametro '" + token + "' del objeto 'N38Sesion' de XLNETS.");
		}
		return resultado;
	}

	/**
	 * Dame de asunto dnicif.
	 * 
	 * @param asuntoP
	 *            the asunto p
	 * @param dniDeParametroXLNETS
	 *            dniDeParametroXLNETS
	 * @return the string
	 * @throws Exception
	 *             the exception
	 */
	private static String dameDeAsuntoDNICIF(String asuntoP, String dniDeParametroXLNETS) throws Exception {
		String dniCif = null;

		if (!Utilidades.isBlank(asuntoP)) {

			final String asunto = asuntoP.toUpperCase();

			if (asunto.indexOf("-DNI") != -1) {
				final String[] subject = asunto.split(",");
				String dni = "";
				for (int i = 0; i < subject.length; i++) {
					if (subject[i].indexOf("-DNI") != -1) {
						dni = subject[i].split("-DNI")[1].trim();
						if (dni.indexOf("-") != -1) {
							dni = dni.split("-")[0];
						} else if (dni.indexOf(" ") != -1) {
							dni = dni.split(" ")[0];
						}
						dni = dni.trim();
						break;
					}
				}

				if (!Utilidades.isBlank(dni)) {
					dniCif = dni;
				}
			} else if (asunto.indexOf("-CIF") != -1) {
				final String[] subject = asunto.split(",");
				String cif = "";

				for (int i = 0; i < subject.length; i++) {
					if (subject[i].indexOf("-CIF") != -1) {
						cif = subject[i].split("-CIF")[1].trim();
						if (cif.indexOf("-") != -1) {
							cif = cif.split("-")[0];
						} else if (cif.indexOf(" ") != -1) {
							cif = cif.split(" ")[0];
						}
						cif = cif.trim();
						break;
					}
				}

				if (!Utilidades.isBlank(cif)) {
					dniCif = cif;
				}
				// para entrar por dni-e
			} else if (asunto.indexOf("SERIALNUMBER=") != -1) {
				final String[] subject = asunto.split(",");
				String dni = "";

				for (int i = 0; i < subject.length; i++) {
					String propiedadesAsunto = subject[i].trim();
					if (propiedadesAsunto.indexOf("SERIALNUMBER=") != -1) {
						dni = propiedadesAsunto.split("SERIALNUMBER=")[1].trim();

						break;
					}
				}

				if (!Utilidades.isBlank(dni)) {
					dniCif = dni;
				}
			}
		}

		Ab18aObtenerDatosXLNETS.logger.debug("############ dniCif: " + dniCif);
		Ab18aObtenerDatosXLNETS.logger.debug("############ param dni xlnets: " + dniDeParametroXLNETS);

		// dniDeParametroXLNETS X0000000

		if (Utilidades.isBlank(dniCif) || (!validarNIFLong9(dniCif) && !validarRES(dniCif))) {
			// Si el identificador obtenido no es un nif/res valido me baso en
			// el parametro de xlnets
			if (!Utilidades.isBlank(dniDeParametroXLNETS)) {
				// Si lo calculado anteriormente no se trata de un nif/res
				// valido me lo cojo de xlnets
				if (validarNIFLong9(dniDeParametroXLNETS) || validarRES(dniDeParametroXLNETS)) {
					// es nif o nie
					dniCif = dniDeParametroXLNETS.toUpperCase();
				} else if (dniDeParametroXLNETS.length() == Constantes.NUMERO_8) {
					if (Utilidades.isInteger(dniDeParametroXLNETS)) {
						dniCif = dniDeParametroXLNETS + calcularLetraFromDNI(dniDeParametroXLNETS);
					} else {
						String dniAux = dniDeParametroXLNETS.substring(1, Constantes.NUMERO_8);
						dniCif = dniDeParametroXLNETS + calcularLetraFromDNI(dniAux);
					}
				}
			}
		}

		Ab18aObtenerDatosXLNETS.logger.debug("############ identificador final: " + dniCif);
		return dniCif;
	}

	/**
	 * Validar nif long9.
	 * 
	 * @param valor
	 *            the valor
	 * @return true, if successful
	 */
	public static boolean validarNIFLong9(String valor) {
		return (validarNIF(valor) && valor.length() == LONGITUD_NIF);
	}

	/**
	 * Validar nif.
	 * 
	 * @param valor
	 *            the valor
	 * @return true, if successful
	 */
	public static boolean validarNIF(String valor) {
		if (!Utilidades.isBlank(valor)) {
			// el valor debe tener 9 o menos posiciones de las cuales las
			// primeras deben ser dÃƒÂ­gitos y la ÃƒÂºltima letra
			// String cadena = "[0-9]{8,8}[A-Z]";
			boolean cifValido = false;
			Pattern pattern = Pattern.compile("(\\d{1,8})([" + CTE_LETRAS_CONTROL_NIF + "])");
			Matcher matcher = pattern.matcher(valor.toUpperCase());
			if (matcher.matches()) {
				String letra = matcher.group(2);

				String letraCalculada = calcularLetraFromDNI(matcher.group(1));
				if (letraCalculada.equalsIgnoreCase(letra)) {
					cifValido = true;
				}
			}
			return cifValido;
		} else {
			return false;
		}
	}

	/**
	 * Calcular letra from dni.
	 * 
	 * @param dni
	 *            the dni
	 * @return the string
	 */
	public static String calcularLetraFromDNI(String dni) {
		String letra = "";
		int posicionModulo = Integer.parseInt(dni) % Constantes.NUMERO_23;
		letra = CTE_LETRAS_CONTROL_NIF.substring(posicionModulo, posicionModulo + 1);
		return letra;
	}

	/**
	 * Validar res.
	 * 
	 * @param valor
	 *            the valor
	 * @return true, if successful
	 */
	public static boolean validarRES(String valor) {
		if (valor != null) {
			// el valor debe tener 9 posiciones, de las cuales las primeras
			// deben ser dÃƒÂ­gitos y la ÃƒÂºltima letra
			String cadena = "[XYZ][0-9]{7,7}[" + CTE_LETRAS_CONTROL_NIF + "]";
			valor = valor.toUpperCase();
			if (valor.matches(cadena)) {
				String primerLetra = valor.substring(0, 1);
				if (primerLetra.equalsIgnoreCase("X")) {
					String dni = valor.substring(1, Constantes.NUMERO_8);
					String letraControl = valor.substring(Constantes.NUMERO_8, Constantes.NUMERO_9);
					// Calculamos la letra de control
					String letraControlCalculado = calcularLetraFromDNI(dni);
					return (letraControlCalculado.equalsIgnoreCase(letraControl));
				} else if (primerLetra.equalsIgnoreCase("Y")) {
					String dni = "1" + valor.substring(1, Constantes.NUMERO_8);
					String letraControl = valor.substring(Constantes.NUMERO_8, Constantes.NUMERO_9);
					// Calculamos la letra de control
					String letraControlCalculado = calcularLetraFromDNI(dni);
					return (letraControlCalculado.equalsIgnoreCase(letraControl));
				} else if (primerLetra.equalsIgnoreCase("Z")) {
					String dni = "2" + valor.substring(1, Constantes.NUMERO_8);
					String letraControl = valor.substring(Constantes.NUMERO_8, Constantes.NUMERO_9);
					// Calculamos la letra de control
					String letraControlCalculado = calcularLetraFromDNI(dni);
					return (letraControlCalculado.equalsIgnoreCase(letraControl));
				} else
					return false;
			} else
				return false;
		} else
			return false;
	}

	/**
	 * Nif from dni.
	 * 
	 * @param dni
	 *            the dni
	 * @return the string
	 */
	public static String nifFromDni(String dni) {

		if (dni.startsWith("X")) {
			dni = dni.substring(1, dni.length());
		} else if (dni.startsWith("Y")) {
			dni = dni.replace('Y', '1');
		} else if (dni.startsWith("Z")) {
			dni = dni.replace('Z', '2');
		}
		int dniInt = Integer.parseInt(dni);

		return String.valueOf(dni) + NIF_STRING_ASOCIATION.charAt(dniInt % Constantes.NUMERO_23);
	}
}
